use strict;
use RTF::TEXT::Converter;
use File::DosGlob 'GLOBAL_glob';
print "**********************************\n";
print "* rtf to txt converter           *\n";
print "* Version: V1.1                  *\n";
print "* Author:  Michael Schlagmueller *\n";
print "**********************************\n";
print "\n";

my $filename;
if (scalar @ARGV < 1	) {
  print "missing parameter (e.g. rtf2txt *.rtf)\n";
} else {

foreach $filename (glob(shift)) {
  print "processing $filename -> $filename.txt\n";

  if (!open (RTF_FILE, "< $filename")) {
	print ("WARN: Can't read file: >$filename< !\n");
	next;
}

if (!open (TXT_FILE, "> $filename.txt")) {
	close RTF_FILE;
	print ("WARN: Can't read file: >$filename.txt< !\n");
	next;
}

      
my $object = RTF::TEXT::Converter->new(
       
	output => \*TXT_FILE,
	sloppy => 1
        
);

$object->parse_stream( \*RTF_FILE );
close RTF_FILE;
close TXT_FILE;
}
}